﻿<%@ control language="vb" CodeBehind="CSEasyListWidget.ascx.vb" Inherits="CSEasyLists.CSEasyListWidget" AutoEventWireup="true" %>
<%@ register tagprefix="ex" assembly="Exact.Web.UI.Controls" namespace="Exact.Web.UI.Controls" %>
<%@ register tagprefix="ex" assembly="Exact.Web.UI.WebParts" namespace="Exact.Web.UI.Controls.WebParts" %>

<ex:webpartproperties runat="server" id="Properties">
	<ex:webpartproperty runat="server" id="wpTitle" caption="Title" captionid="10189" PropertyCSS="WebPartFavTitle">
		<ex:inputfield runat="server" id="TitleField"/>
	</ex:webpartproperty>
	<ex:webpartproperty runat="server" id="wpEasyList" caption="Easy list" captionid="0" PropertyCSS="WebPartFavTitle">
		<ex:BrowseField runat="server" id="bfEasyList" StandardBrowser="Request" BrowserWhereClause="Absences.Type = IsNull((select top 1 LongValue from BacoSettings where SettingType = 0 and SettingName = 'CSEasyListRequestType'), -1) and Absences.Status in (1, 4, 3)" AllowEmpty="False" InputHidden="True" OnChange="EasyListSelected();" />
	</ex:webpartproperty>
	<ex:webpartproperty runat="server" id="wpParameters" caption="Parameters" captionid="26031">
		<ex:BrowseField runat="server" id="Parameters" InputHidden="True" StandardBrowser="Request" />
        <span class="entryGridWarning" id="InvalidFlagParameters" style="vertical-align:bottom;"><img id="ParametersMandatory" src="images/exclamation.svg" /></span><span id="ParametersValidFlag" style="vertical-align:bottom;"><img id="ParametersValid" src="images/check.svg" /></span>
	</ex:webpartproperty>
	<ex:webpartproperty runat="server" id="wpParametersJson" caption="Parameters" captionid="26031" captionSuffix=":Json" captionsuffixid="0" PropertyCSS="WebPartFavTitle">
		<ex:inputfield runat="server" id="ParametersJson"/>
	</ex:webpartproperty>
	<ex:webpartproperty runat="server" id="wpIconField" caption="Picture" captionid="220" PropertyCSS="WebPartFavTitle">
		<ex:ComboBox runat="server" id="IconField" AllowEmpty="True" ValidationDefault="WidgetThumbnail_List1.svg" onChange="IconFieldChanged(this);">
			<ex:listitem caption="mailmerge.svg" captionid="0" value="mailmerge.svg" />
			<ex:listitem caption="opportunities.svg" captionid="0" value="opportunities.svg" />
			<ex:listitem caption="order.svg" captionid="0" value="order.svg" />
			<ex:listitem caption="print.svg" captionid="0" value="print.svg" />
			<ex:listitem caption="production.svg" captionid="0" value="production.svg" />
			<ex:listitem caption="profitandloss.svg" captionid="0" value="profitandloss.svg" />
			<ex:listitem caption="project_card.svg" captionid="0" value="project_card.svg" />
			<ex:listitem caption="purchaseTOpay.svg" captionid="0" value="purchaseTOpay.svg" />
			<ex:listitem caption="readlog.svg" captionid="0" value="readlog.svg" />
			<ex:listitem caption="report.svg" captionid="0" value="report.svg" />
			<ex:listitem caption="result.svg" captionid="0" value="result.svg" />
			<ex:listitem caption="resume.svg" captionid="0" value="resume.svg" />
			<ex:listitem caption="schema-system.svg" captionid="0" value="schema-system.svg" />
			<ex:listitem caption="schema-user.svg" captionid="0" value="schema-user.svg" />
			<ex:listitem caption="SDK.svg" captionid="0" value="SDK.svg" />
			<ex:listitem caption="sent.svg" captionid="0" value="sent.svg" />
			<ex:listitem caption="service_managers.svg" captionid="0" value="service_managers.svg" />
			<ex:listitem caption="service-contract.svg" captionid="0" value="service-contract.svg" />
			<ex:listitem caption="settings.svg" captionid="0" value="settings.svg" />
			<ex:listitem caption="stack_of_photos.svg" captionid="0" value="stack_of_photos.svg" />
			<ex:listitem caption="statistics.svg" captionid="0" value="statistics.svg" />
			<ex:listitem caption="student.svg" captionid="0" value="student.svg" />
			<ex:listitem caption="suppliers.svg" captionid="0" value="suppliers.svg" />
			<ex:listitem caption="suspect.svg" captionid="0" value="suspect.svg" />
			<ex:listitem caption="temporary.svg" captionid="0" value="temporary.svg" />
			<ex:listitem caption="toolbar.svg" captionid="0" value="toolbar.svg" />
			<ex:listitem caption="trafficlightgreen.svg" captionid="0" value="trafficlightgreen.svg" />
			<ex:listitem caption="trafficlightred.svg" captionid="0" value="trafficlightred.svg" />
			<ex:listitem caption="trafficlightyellow.svg" captionid="0" value="trafficlightyellow.svg" />
			<ex:listitem caption="transaction.svg" captionid="0" value="transaction.svg" />
			<ex:listitem caption="user.svg" captionid="0" value="user.svg" />
			<ex:listitem caption="users.svg" captionid="0" value="users.svg" />
			<ex:listitem caption="vacancy.svg" captionid="0" value="vacancy.svg" />
			<ex:listitem caption="vacation.svg" captionid="0" value="vacation.svg" />
			<ex:listitem caption="webpart_default.svg" captionid="0" value="webpart_default.svg" />
			<ex:listitem caption="WidgetThumbnail_Contracts.svg" captionid="0" value="WidgetThumbnail_Contracts.svg" />
			<ex:listitem caption="WidgetThumbnail_List1.svg" captionid="0" value="WidgetThumbnail_List1.svg" />
			<ex:listitem caption="WidgetThumbnail_List2.svg" captionid="0" value="WidgetThumbnail_List2.svg" />
			<ex:listitem caption="WidgetThumbnail_List3.svg" captionid="0" value="WidgetThumbnail_List3.svg" />
			<ex:listitem caption="WidgetThumbnail_Me.svg" captionid="0" value="WidgetThumbnail_Me.svg" />
			<ex:listitem caption="WidgetThumbnail_Pivot.svg" captionid="0" value="WidgetThumbnail_Pivot.svg" />
			<ex:listitem caption="WidgetThumbnail_Text.svg" captionid="0" value="WidgetThumbnail_Text.svg" />
			<ex:listitem caption="workflow.svg" captionid="0" value="workflow.svg" />
		</ex:ComboBox>
		<img id="IconFieldPreview" height="16" width="16" src="images/Blank.png" />
	</ex:webpartproperty>
</ex:webpartproperties>

<ex:inputfield runat="server" id="Action" validationas="Int" hidden="true" />
<ex:inputfield runat="server" id="SelectedFavorite" validationas="Guid" hidden="true" />

<ex:bcerrormessages runat="server" id="errLicense" Mode="Error" />
<ex:listview runat="server" id="ResultList" hidecaption="true" showborder="false" showwaitmessage="True" ScrollBar="Always">
	<Columns />
</ex:listview>
<ex:bcerrormessages runat="server" id="errNoDataFound" Mode="Notification" />

<script type="text/javascript">
    var CSEasyList_CurrentValue = '';
    var CSEasyList_NeedParams = false;
    var CSEasyList_OkClick = null;
    function IconFieldChanged(sender) {
        if (sender.value == '') {
            $('#IconFieldPreview').attr('src', 'images/Blank.png');
        } else {
            $('#IconFieldPreview').attr('src', 'images/' + sender.value);
        }
    }

    function EasyListSelected() {
        var el_id = $("[id$='bfEasyList']").val();
        if (el_id != CSEasyList_CurrentValue) {
            $('#lbl_wpParametersJson').parent().find('input[id$="_ParametersJson"]').val('');
        }
        CSEasyList_CurrentValue = el_id;

        var url = 'CSEasyListParamsCallback.aspx?id=' + el_id;
        var cx = SysCbLoadList(url);
        if (cx != null) {
            if (SysCbGetValue(cx, 'NeedParameters') == 1) {
                $('#lbl_wpParameters').parent().show();
                CSEasyList_NeedParams = true;
                $('#InvalidFlagParameters').show();
                $('#ParametersValidFlag').hide();
            } else {
                $('#lbl_wpParameters').parent().hide();
                CSEasyList_NeedParams = false;
                $('#InvalidFlagParameters').hide();
                $('#ParametersValidFlag').hide();
            }
        }
    }

    function ShowParameters(sender) {
        var jsonparams = $('#lbl_wpParametersJson').parent().find('input[id$="_ParametersJson"]').val();

        var callback = function () {
            var newtext = SysDialog.returnValue;
            if (newtext != null) {
                $('#lbl_wpParametersJson').parent().find('input[id$="_ParametersJson"]').val(newtext);
                $('#InvalidFlagParameters').hide();
                $('#ParametersValidFlag').show();
            } else {
                if (jsonparams == '') {
                    $('#InvalidFlagParameters').show();
                    $('#ParametersValidFlag').hide();
                } else {
                    $('#InvalidFlagParameters').hide();
                    $('#ParametersValidFlag').show();
                }
            }
        }
        var popupSize = getDesiredPopupSize();
        SysShowModalPopup('CSEasyListParams.aspx?InWidget=1&ID=' + CSEasyList_CurrentValue + '&ParamsJson=' + SysURLEncode(jsonparams), null, popupSize.width, popupSize.height, callback, null, "scroll:no;");
    }

    $(function () {
        if ($('#lbl_wpParameters').length == 0) return;

        $('#lbl_wpParametersJson').parent().hide();

        $('#lbl_wpParameters').parent().find('button[id$="_Parameters"]').attr('onclick', 'ShowParameters(this);');

        CSEasyList_CurrentValue = $("[id$='bfEasyList']").val();

        var jsonparams = $('#lbl_wpParametersJson').parent().find('input[id$="_ParametersJson"]').val();

        if (jsonparams == '') {
            $('#lbl_wpParameters').parent().hide();
            CSEasyList_NeedParams = false;
            $('#InvalidFlagParameters').hide();
            $('#ParametersValidFlag').hide();
        } else {
            $('#lbl_wpParameters').parent().show();
            CSEasyList_NeedParams = true;
            $('#InvalidFlagParameters').hide();
            $('#ParametersValidFlag').show();
        }

        if (CSEasyList_OkClick == null) {
            CSEasyList_OkClick = $('#okVerb').attr('onclick');
            $('#okVerb').attr('onclick', 'CSEasyListOkVerb();')
        }
    });

    function CSEasyListOkVerb() {
        if (CSEasyList_OkClick == null)
            return;

        var jsonparams = $('#lbl_wpParametersJson').parent().find('input[id$="_ParametersJson"]').val();

        if (CSEasyList_NeedParams && jsonparams == '') {
            var msg = 'U dient eerst de parameters te vullen voor deze Easy List';
            SysShowModalPopup(SysConfirmUrl(5, 0, msg, null), null, SysConfirmWidth(msg), SysConfirmHeight(msg), null, null, 'scroll:no;');
            return;
        }

        eval(CSEasyList_OkClick);
    }
</script>
<script type="text/javascript" src="CSEasyList.js?v=1"></script>