﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="CSEasyListExport.aspx.vb" Inherits="CSEasyLists.CSEasyListExport" %>
<%@ register tagprefix="ex" namespace="Exact.Web.UI.Controls" assembly="Exact.Web.UI.Controls" %>

<html>
<head>
    <title></title>
    <link runat="server" id="ExactCSS" href="Exact.css" type="text/css" rel="stylesheet" />
    <script language="javascript" type="text/javascript" src="jquery.js"></script>
    <script language="javascript" type="text/javascript">
        function ExportClicked() {
            if (!lvcCheckCheckedListDefinitions_cCheck()) {
                SysAlert(13926, 'You haven\'t selected anything.');
                return;
            }
            SysSet('DoExport', 1);
            SysSubmit();
        }
    </script>
</head>
<body>
<ep:form id="Baco" runat="server">

<ex:InputField runat="server" ID="DoExport" CreateClientControl="True" Hidden="True" ValidationAs="Int" ValidationDefault="0" />
<ex:InputField runat="server" ID="ExportID" CreateClientControl="True" Hidden="True" ValidationAs="Guid" />

<ex:CardControl runat="server" ID="Card" Action="Show">
    <ex:header id="hdr" caption="Easy Lists" captionid="0" CaptionSuffix=":Export" CaptionSuffixID="8577" runat="server" showsitemappath="false">
        <ex:headerbutton id="hbFavorite" buttonstyle="Favorite" />
    </ex:header>

    <ex:headerproperties runat="server" id="hdrProps" HeaderPropertiesStyle="Custom" />

    <ex:buttonbar runat="server" id="Buttons">
        <ex:button runat="server" id="btnRefresh" buttonstyle="Refresh" onClick="SysSubmit(1);" />
        <ex:button runat="server" id="btnExport" buttonstyle="Custom" Caption="Export" CaptionID="8577" onClick="ExportClicked();" />
        <ex:button runat="server" id="btnClose" buttonstyle="Close" />
    </ex:buttonbar>

    <ex:bcerrormessages runat="server" id="errmsg" Mode="Notification" />

    <ex:cardrow runat="server" id="crFilter">
        <ex:cardcolumn runat="server" id="ccFilter">
		    <ex:cardsection runat="server" id="csFilter" caption="Filter" captionid="1378">
				<ex:cardfield runat="server" id="cfFilter" caption="Status" captionid="4332">
					<ex:checkboxlist runat="server" id="Status" validationas="int" />
				</ex:cardfield>
                <ex:cardfield runat="server" id="cfFilterDescription" caption="Title" captionid="10189">
                    <ex:imagebuttonlist runat="server" id="DescriptionOperator" appearance="Toggle" validationas="int" validationdefault="5" imageheight="">
					    <ex:listitem value="5" caption="Starts with" captionid="390" image="startwith.svg"  />
					    <ex:listitem value="6" caption="Contains" captionid="16440" image="wildcard.svg" />
					    <ex:listitem value="0" caption="Equal to" captionid="371" image="equalto.svg" />
				    </ex:imagebuttonlist>
					<ex:inputfield runat="server" id="Description" />
				</ex:cardfield>
                <ex:cardfield runat="server" id="cfFilterModified" caption="Modified" captionid="53">
					<ex:daterange runat="server" id="Modified" validationas="DateTime" ShowQuickSelect="True" />
				</ex:cardfield>
            </ex:cardsection>
        </ex:cardcolumn>
    </ex:cardrow>

    <ex:cardrow runat="server" id="crDefinitions" >
	    <ex:cardcolumn runat="server" id="ccDefinitions" Caption="Easy Lists" CaptionID="0">
			<ex:cardlistview runat="server" id="csDefinitions" showheader="True" customizecolumns="False" customizerows="False">
				<ex:listview runat="server" id="ListDefinitions" Caption="Easy Lists" CaptionID="0" showbutton="False" showpagesize="false" ongetdata="ListDefinitionsOnGetData" onquery="ListDefinitionsOnQuery" ruler="false" DefaultSortColumn="colModified" DefaultSortDescending="True" Autopostback="True">
                    <Columns>
                        <ex:listviewcheckboxcolumn runat="server" id="cCheck" type="selectall" selectallprefix="chk" align="Center" width="5%" />
                        <ex:listviewcolumn runat="server" id="colTitle" captionid="10189" caption="Title" width="65%" EnableSorting="True" />
                        <ex:listviewcolumn runat="server" id="colID" captionid="0" caption="ID" width="5%" EnableSorting="True" />
                        <ex:listviewcolumn runat="server" id="colStatus" captionid="4332" caption="Status" width="10%" EnableSorting="True" />
                        <ex:listviewcolumn runat="server" id="colCreated" captionid="2468" caption="Created" width="10%" EnableSorting="True" />
                        <ex:listviewcolumn runat="server" id="colModified" captionid="53" caption="Modified" width="10%" EnableSorting="True" />
                    </Columns>
				</ex:listview>
			</ex:cardlistview>
        </ex:cardcolumn>
    </ex:cardrow>

</ex:CardControl>
</ep:form>
</body>
</html>