﻿if not exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'SectionType')
begin
	alter table [dbo].[CSEasyScriptSections]
		add [SectionType] [nchar](1) NOT NULL default('S')
end
go

delete from DDTests where Tablename = 'CSEasyScriptSections' and FieldName = 'SectionType'
go

insert into DDTests(DatabaseChar, Tablename, FieldName, DisplayChar, Description, TermId, Options, SeqNr) values('S', 'CSEasyScriptSections', 'SectionType', 'S', 'Section', 11133, '', 0)
insert into DDTests(DatabaseChar, Tablename, FieldName, DisplayChar, Description, TermId, Options, SeqNr) values('T', 'CSEasyScriptSections', 'SectionType', 'T', 'Tab', 15938, '', 1)
go

if not exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'ParentSectionID')
begin
	alter table [dbo].[CSEasyScriptSections]
		add [ParentSectionID] [uniqueidentifier] NULL
end
go


if object_id('FK_CSEasyScriptSections_ParentSectionID') is null
begin
	ALTER TABLE [dbo].[CSEasyScriptSections]  ADD  CONSTRAINT [FK_CSEasyScriptSections_ParentSectionID] FOREIGN KEY([ParentSectionID])
	REFERENCES [dbo].[CSEasyScriptSections] ([ID])
end
go


if exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'Script' and IS_NULLABLE = 'NO')
begin
	alter table CSEasyScriptSections
	alter column Script [nvarchar](max) NULL
end
go

if not exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'ShowCaption')
begin
	alter table [dbo].[CSEasyScriptSections]
		add [ShowCaption] [tinyint] NOT NULL default(1)
end
go


if not exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSupportedPages' and COLUMN_NAME = 'BusinessComponent')
begin
	alter table [dbo].[CSEasyScriptSupportedPages]
		add [BusinessComponent] [nvarchar](128) NOT NULL default('')
end
go

update CSEasyScriptSupportedPages set BusinessComponent = 'Item' where ASPXPage = 'LogItem.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Item' where ASPXPage = 'LogItemCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Employee' where ASPXPage = 'HRMResourceCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Employee' where ASPXPage = 'HRMResource.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Associates' where ASPXPage = 'CRMAccountCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Associates' where ASPXPage = 'CRMAccountMaint.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Associates' where ASPXPage = 'CRMPersonAccountCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Associates' where ASPXPage = 'CRMPersonAccountMaint.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Contact' where ASPXPage = 'CRMContactMaint.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Contact' where ASPXPage = 'CRMContactCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Opportunities' where ASPXPage = 'CRMOpportunityCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'Opportunities' where ASPXPage = 'CRMOpportunityMaint.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'PRProject' where ASPXPage = 'ProEdit.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'PRProject' where ASPXPage = 'ProCard.aspx'
update CSEasyScriptSupportedPages set BusinessComponent = 'ItemNumber' where ASPXPage = 'LogItemNumber.aspx'
go




if not exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'RoleIDs')
begin
	alter table [dbo].[CSEasyScriptSections]
		add [RoleIDs] [nvarchar](max) NULL
end
go

if exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'RoleID')
begin
	update CSEasyScriptSections
	set RoleIDs = RoleID
	where RoleID is not null

	alter table [dbo].[CSEasyScriptSections]
		drop column [RoleID]
end
go

update CSEasyScriptSupportedPages set KeyInputField = 'ProjectNr' where ASPXPage in ('ProEdit.aspx')
update CSEasyScriptSupportedPages set KeyInputField = 'ID' where ASPXPage in ('CRMAccountMaint.aspx', 'CRMPersonAccountMaint.aspx')
update CSEasyScriptSupportedPages set KeyInputField = 'ContactID' where ASPXPage in ('CRMContactMaint.aspx')
update CSEasyScriptSupportedPages set KeyInputField = 'ID' where ASPXPage in ('HRMResource.aspx')
update CSEasyScriptSupportedPages set KeyInputField = 'ID' where ASPXPage in ('CRMOpportunityMaint.aspx')
update CSEasyScriptSupportedPages set KeyInputField = 'ItemCode' where ASPXPage in ('LogItem.aspx')
update CSEasyScriptSupportedPages set KeyInputField = 'ID' where ASPXPage in ('LogItemNumber.aspx')
go


if not exists(select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = 'CSEasyScriptSections' and COLUMN_NAME = 'DisplayOrder')
begin
	alter table [dbo].[CSEasyScriptSections]
		add [DisplayOrder] [int] NOT NULL default(0)
end
go
