﻿
if object_id('CSEasyScriptSupportedPages') is null
begin
	CREATE TABLE [dbo].[CSEasyScriptSupportedPages](
		[ID] [uniqueidentifier] NOT NULL,
		[Caption] [nvarchar](50) NOT NULL,
		[CaptionID] [int] NOT NULL,
		[ASPXPage] [nvarchar](255) NOT NULL,
		[DefaultColumn] [nvarchar](255) NULL,
		[DefaultRow] [nvarchar](255) NULL,
		[IsMaintScreen] [tinyint] NOT NULL DEFAULT(0),
		[TableName] [nvarchar](255) NULL,
		[KeyColumn] [nvarchar](255) NULL,
		[KeyInputField] [nvarchar](255) NULL
	 CONSTRAINT [PK_CSEasyScriptSupportedPages] PRIMARY KEY CLUSTERED 
	(
		[ID] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
end
GO

if object_id('CSEasyScriptSections') is null
begin
	CREATE TABLE [dbo].[CSEasyScriptSections](
		[ID] [uniqueidentifier] NOT NULL,
		[Caption] [nvarchar](50) NOT NULL,
		[CaptionID] [int] NOT NULL,
		[Description] [nvarchar](max) NULL,
		[PageID] [uniqueidentifier] NOT NULL,
		[Script] [nvarchar](max) NOT NULL,
		[Enabled] [tinyint] NOT NULL,
		[RoleID] [int] NULL,
		[Criteria] [nvarchar](255) NULL,
		[Syscreator] [int] NOT NULL default(0),
		[Syscreated] [datetime] NOT NULL default(getdate()),
		[Sysmodifier] [int] NOT NULL default(0),
		[Sysmodified] [datetime] NOT NULL default(getdate()),
	 CONSTRAINT [PK_CSEasyScriptSections] PRIMARY KEY CLUSTERED 
	(
		[ID] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

	ALTER TABLE [dbo].[CSEasyScriptSections] ADD  CONSTRAINT [DF_CSEasyScriptSections_CaptionID]  DEFAULT ((0)) FOR [CaptionID]

	ALTER TABLE [dbo].[CSEasyScriptSections]  WITH CHECK ADD  CONSTRAINT [FK_CSEasyScriptSections_CSEasyScriptSupportedPages] FOREIGN KEY([PageID])
	REFERENCES [dbo].[CSEasyScriptSupportedPages] ([ID])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[CSEasyScriptSections] CHECK CONSTRAINT [FK_CSEasyScriptSections_CSEasyScriptSupportedPages]
end
GO


if not exists(select * from [dbo].[CSEasyScriptSupportedPages] where ASPXPage = N'HRMResourceCard.aspx')
begin
	insert into [dbo].[CSEasyScriptSupportedPages](ID, Caption, CaptionID, ASPXPage, DefaultColumn)
	values(newId(), N'Resource', 12, N'HRMResourceCard.aspx', N'Column1')
end
go

if not exists(select * from [dbo].[CSEasyScriptSupportedPages] where ASPXPage = N'CRMAccountCard.aspx')
begin
	insert into [dbo].[CSEasyScriptSupportedPages](ID, Caption, CaptionID, ASPXPage, DefaultColumn)
	values(newId(), N'Account', 8, N'CRMAccountCard.aspx', N'ccMain1')
end
go

if not exists(select * from [dbo].[CSEasyScriptSupportedPages] where ASPXPage = N'CRMPersonAccountCard.aspx')
begin
	insert into [dbo].[CSEasyScriptSupportedPages](ID, Caption, CaptionID, ASPXPage, DefaultColumn)
	values(newId(), N'Person', 8476, N'CRMPersonAccountCard.aspx', N'ccMain1')
end
go

if not exists(select * from [dbo].[CSEasyScriptSupportedPages] where ASPXPage = N'ProCard.aspx')
begin
	insert into [dbo].[CSEasyScriptSupportedPages](ID, Caption, CaptionID, ASPXPage, DefaultColumn)
	values(newId(), N'Project', 8657, N'ProCard.aspx', N'Row1Column1')
end
go
